// Export all from wp.url
const url = window.wp?.url || {};

// Re-export the entire url object as both default and named exports
export default url;

// Export commonly used url utilities
export const {
  addQueryArgs,
  getQueryArg,
  getQueryArgs,
  hasQueryArg,
  removeQueryArgs,
  prependHTTP,
  safeDecodeURI,
  safeDecodeURIComponent,
  filterURLForDisplay,
  getAuthority,
  isValidAuthority,
  getProtocol,
  isValidProtocol,
  getPath,
  isValidPath,
  getQueryString,
  isValidQueryString,
  getPathAndQueryString,
  getFragment,
  isValidFragment,
  addPathPrefix,
  cleanForSlug,
  isURL,
  isEmail,
  getFilename,
  normalizePath,
} = url;
