// WordPress @wordpress/rich-text shim
// Exports from wp.richText global

const richText = window.wp?.richText || {};

export const create = richText.create || ((options) => ({ text: options?.html || options?.text || "", formats: [], replacements: [] }));
export const insert = richText.insert || ((value, insertValue) => value);
export const remove = richText.remove || ((value) => value);
export const replace = richText.replace || ((value) => value);
export const split = richText.split || ((value) => [value]);
export const join = richText.join || ((values) => values[0] || { text: "", formats: [], replacements: [] });
export const concat = richText.concat || ((...values) => values[0] || { text: "", formats: [], replacements: [] });
export const slice = richText.slice || ((value) => value);
export const isEmpty = richText.isEmpty || ((value) => !value?.text?.length);
export const isCollapsed = richText.isCollapsed || ((value) => value?.start === value?.end);
export const getActiveFormat = richText.getActiveFormat || (() => undefined);
export const getActiveFormats = richText.getActiveFormats || (() => []);
export const applyFormat = richText.applyFormat || ((value) => value);
export const removeFormat = richText.removeFormat || ((value) => value);
export const toggleFormat = richText.toggleFormat || ((value) => value);
export const toHTMLString = richText.toHTMLString || ((value) => value?.text || "");

export default richText;
