// Export all from wp.icons
// We can't destructure all possible icons, so we'll use a Proxy to dynamically
// export any icon that's requested
const icons = window.wp?.icons || {};

// Re-export the entire icons object as both default and named exports
export default icons;

// Export commonly used icons explicitly for better tree-shaking
export const {
  Icon,
  image,
  check,
  close,
  closeSmall,
  upload,
  download,
  edit,
  trash,
  plus,
  search,
  settings,
  update,
  play,
  pause,
  filter,
  microphone,
  xMark,
  moreVertical,
  thumbsUp,
  thumbsDown,
  lockOutline,
  chevronDown,
  chevronUp,
  chevronLeft,
  chevronRight,
  arrowLeft,
  arrowRight,
  arrowUp,
  arrowDown,
  warning,
  info,
  help,
  external,
  link,
  linkOff,
  seen,
  unseen,
  star,
  starEmpty,
  starFilled,
  calendar,
  comment,
  envelope,
  layout,
  blockDefault,
  category,
  tag,
  postContent,
  page,
  post,
  globe,
  backup,
  cloud,
  cloudUpload,
  home,
  inbox,
  media,
  menu,
  more,
  pin,
  desktop,
  mobile,
  tablet,
  tool,
  cog,
  wordpress,
  chartBar,
  code,
  lock,
  unlock,
  cancelCircleFilled,
  checkboxChecked,
  checkboxUnchecked,
  plugins,
  people,
  addCard,
  users,
  posts,
  pages,
  pencil,
  formatBold,
  formatItalic,
  formatStrikethrough,
  formatListBullets,
  formatListNumbered,
  quote,
  alignLeft,
  alignCenter,
  alignRight,
  alignJustify,
  heading,
  paragraph,
  file,
  archive,
  audio,
  video,
  button,
  columns,
  cover,
  embed,
  gallery,
  group,
  html,
  preformatted,
  pullquote,
  reusableBlock,
  separator,
  shortcode,
  spacer,
  table,
  verse,
  width,
  rotateLeft,
  rotateRight,
  flipHorizontal,
  flipVertical,
  crop,
  aspectRatio,
  stretchWide,
  stretchFullWidth,
  positionLeft,
  positionCenter,
  positionRight,
  blockTable,
  capturePhoto,
  captureVideo,
  chartLine,
  cloudDownload,
  cloudSaved,
  cloudUploading,
  commentAuthorAvatar,
  commentAuthorName,
  commentContent,
  commentReplyLink,
  commentEditLink,
  commentsNumber,
  symbol,
  textColor,
  formatCapitalize,
  formatLowercase,
  formatUppercase,
  formatLtr,
  formatRtl,
  formatIndent,
  formatIndentRTL,
  formatOutdent,
  formatOutdentRTL,
  trendingUp,
  trendingDown,
  dragHandle,
  navigation,
  lifesaver,
  receipt,
  payment,
  shipping,
  atSymbol,
  percent,
  currencyDollar,
  currencyEuro,
  currencyPound,
  tip,
  school,
  shield,
  store,
  cart,
  login,
  logout,
  key,
  keyboardReturn,
  typography,
  customLink,
  brush,
  styles,
  overlayText,
  justify,
  list,
  listView,
  pullLeft,
  pullRight,
  sidebarRight,
  sidebarLeft,
  blockDefault: blockDefault2,
  fullscreen,
  resize,
  share,
  copy,
  seen: seen2,
  unseen: unseen2,
  undo,
  redo,
  refresh,
  reset,
  close: close2,
  chevronLeft: chevronLeft2,
  chevronRight: chevronRight2,
  chevronDown: chevronDown2,
  chevronUp: chevronUp2
} = icons;

// For any icons not explicitly listed above, they can still be accessed via:
// import icons from '@wordpress/icons'
// and then use: icons.anyIconName
