// Export all from wp.i18n with fallbacks
const i18n = window.wp?.i18n || {};

// __ with fallback to just returning the string
export const __ = i18n.__ || ((text) => text);

// _x with fallback
export const _x = i18n._x || ((text) => text);

// _n with fallback
export const _n = i18n._n || ((single, plural, number) => (number === 1 ? single : plural));

// _nx with fallback
export const _nx = i18n._nx || ((single, plural, number) => (number === 1 ? single : plural));

// sprintf with fallback - simple implementation
export const sprintf = i18n.sprintf || ((format, ...args) => {
  let i = 0;
  return format.replace(/%[sd%]/g, (match) => {
    if (match === '%%') return '%';
    return args[i++] ?? match;
  });
});

// setLocaleData with fallback
export const setLocaleData = i18n.setLocaleData || (() => {});

export default i18n;
