// WordPress @wordpress/editor and @wordpress/edit-post shim
// Exports from wp.editor global (WP 6.6+) with fallback to wp.editPost (older)

const editor = window.wp?.editor || {};
const editPost = window.wp?.editPost || {};

// From @wordpress/editor
export const EditorProvider = editor.EditorProvider || (() => null);
export const BlockEditorProvider = editor.BlockEditorProvider || (() => null);
export const DocumentOutline = editor.DocumentOutline || (() => null);
export const RichText = editor.RichText || (() => null);
export const PostTitle = editor.PostTitle || (() => null);
export const PostExcerpt = editor.PostExcerpt || (() => null);
export const PostPermalink = editor.PostPermalink || (() => null);
export const PostSlug = editor.PostSlug || (() => null);
export const PostTextEditor = editor.PostTextEditor || (() => null);
export const PostVisibility = editor.PostVisibility || (() => null);
export const PostPublishButton = editor.PostPublishButton || (() => null);
export const PostSavedState = editor.PostSavedState || (() => null);
export const PostSchedule = editor.PostSchedule || (() => null);

// Plugin components - WP 6.6+ moved these from edit-post to editor
// Check editor first (new location), then editPost (old location)
export const PluginSidebar = editor.PluginSidebar || editPost.PluginSidebar || (() => null);
export const PluginSidebarMoreMenuItem = editor.PluginSidebarMoreMenuItem || editPost.PluginSidebarMoreMenuItem || (() => null);
export const PluginDocumentSettingPanel = editor.PluginDocumentSettingPanel || editPost.PluginDocumentSettingPanel || (() => null);
export const PluginPostStatusInfo = editor.PluginPostStatusInfo || editPost.PluginPostStatusInfo || (() => null);
export const PluginPrePublishPanel = editor.PluginPrePublishPanel || editPost.PluginPrePublishPanel || (() => null);
export const PluginPostPublishPanel = editor.PluginPostPublishPanel || editPost.PluginPostPublishPanel || (() => null);
export const PluginBlockSettingsMenuItem = editor.PluginBlockSettingsMenuItem || editPost.PluginBlockSettingsMenuItem || (() => null);
export const PluginMoreMenuItem = editor.PluginMoreMenuItem || editPost.PluginMoreMenuItem || (() => null);

export default { ...editor, ...editPost };

// Editor store - for useSelect with editorStore
export const store = 'core/editor';
