// Export all from wp.compose
// WordPress Compose library provides hooks and higher-order components
const compose = window.wp?.compose || {};

// Export the entire compose object as default
export default compose;

// Export all WordPress Compose utilities and hooks
export const {
  // Higher-order components
  compose: composeHOC,
  createHigherOrderComponent,
  ifCondition,
  pure,
  withGlobalEvents,
  withInstanceId,
  withSafeTimeout,
  withState,

  // Hooks
  useKeyboardShortcut,
  useMediaQuery,
  useReducedMotion,
  useViewportMatch,
  useFocusReturn,
  useFocusOnMount,
  useConstrainedTabbing,
  useMergeRefs,
  useRefEffect,
  useDisabled,
  useCopyOnClick,
  useCopyToClipboard,
  useFocusableIframe,
  useFixedWindowScroll,
  useFocusOutside,
  useIsomorphicLayoutEffect,
  usePrevious,
  useDebounce,
  useThrottle,
  useDebouncedInput,

  // Utilities
  __experimentalUseDialog,
  __experimentalUseFocusOutside,
  __experimentalUseDropZone
} = compose;
