// WordPress @wordpress/blocks shim
// Exports from wp.blocks global

const blocks = window.wp?.blocks || {};

export const createBlock = blocks.createBlock || ((name, attributes, innerBlocks) => ({
  name,
  attributes: attributes || {},
  innerBlocks: innerBlocks || [],
  clientId: Math.random().toString(36).substr(2, 9),
  isValid: true,
}));

export const registerBlockType = blocks.registerBlockType || (() => null);
export const unregisterBlockType = blocks.unregisterBlockType || (() => null);
export const getBlockType = blocks.getBlockType || (() => null);
export const getBlockTypes = blocks.getBlockTypes || (() => []);
export const hasBlockSupport = blocks.hasBlockSupport || (() => false);
export const isReusableBlock = blocks.isReusableBlock || (() => false);
export const isTemplatePart = blocks.isTemplatePart || (() => false);
export const cloneBlock = blocks.cloneBlock || ((block) => ({ ...block }));
export const serialize = blocks.serialize || (() => "");
export const parse = blocks.parse || (() => []);
export const pasteHandler = blocks.pasteHandler || (() => []);
export const rawHandler = blocks.rawHandler || (() => []);
export const getBlockContent = blocks.getBlockContent || (() => "");
export const getSaveContent = blocks.getSaveContent || (() => "");
export const getSaveElement = blocks.getSaveElement || (() => null);
export const getBlockDefaultClassName = blocks.getBlockDefaultClassName || (() => "");

export default blocks;
