// Export all from wp.blockEditor
// WordPress Block Editor provides components and utilities for the block editor
const blockEditor = window.wp?.blockEditor || {};

// Export the entire blockEditor object as default
export default blockEditor;

// Export all WordPress Block Editor components and utilities
export const {
  // Media components
  MediaUpload,
  MediaUploadCheck,
  MediaPlaceholder,

  // Inspector controls
  InspectorControls,
  InspectorAdvancedControls,

  // Block controls
  BlockControls,
  AlignmentToolbar,
  BlockAlignmentToolbar,
  BlockVerticalAlignmentToolbar,

  // Rich text
  RichText,
  RichTextToolbarButton,
  RichTextShortcut,

  // Color controls
  ColorPalette,
  ContrastChecker,
  PanelColorSettings,
  withColors,
  getColorClassName,
  getColorObjectByColorValue,
  getColorObjectByAttributeValues,

  // Typography
  FontSizePicker,
  withFontSizes,

  // Block utilities
  useBlockProps,
  useInnerBlocksProps,
  InnerBlocks,
  BlockIcon,

  // Inserter
  __experimentalBlockVariationPicker,
  __experimentalUseBlockPreview,

  // Other utilities
  URLInput,
  URLInputButton,
  URLPopover,

  // Store selectors and actions (if needed)
  store
} = blockEditor;
