/**
 * WordPress Packages Shim
 *
 * This file provides exports for all WordPress packages by re-exporting
 * the global wp object and its properties as named exports.
 *
 * Each WordPress package has its own specific API, so we export the
 * entire wp global and let the consuming code access what it needs.
 */

// Ensure wp global exists
const wp = window.wp || {};

// For @wordpress/dom-ready - default export
export const domReady = wp.domReady;

// For @wordpress/element - React-like API from wp.element
export const {
  createElement,
  Component,
  Fragment,
  createContext,
  forwardRef,
  lazy,
  memo,
  StrictMode,
  Suspense,
  useState,
  useEffect,
  useContext,
  useReducer,
  useCallback,
  useMemo,
  useRef,
  useImperativeHandle,
  useLayoutEffect,
  useDebugValue,
  Children,
  isValidElement,
  cloneElement,
  createPortal,
  findDOMNode,
  render,
  hydrate,
  unmountComponentAtNode,
  createRoot,
  hydrateRoot
} = wp.element || {};

// For @wordpress/components - export the whole module
export const {
  Button,
  Card,
  CardBody,
  CardDivider,
  CardFooter,
  CardHeader,
  CardMedia,
  CheckboxControl,
  ColorPicker,
  Disabled,
  Draggable,
  DropZone,
  Dropdown,
  DropdownMenu,
  ExternalLink,
  Flex,
  FlexBlock,
  FlexItem,
  FocalPointPicker,
  FormFileUpload,
  FormToggle,
  FormTokenField,
  Icon,
  IconButton,
  MenuItem,
  MenuGroup,
  Modal,
  NavigableMenu,
  Notice,
  NoticeList,
  Panel,
  PanelBody,
  PanelHeader,
  PanelRow,
  Placeholder,
  Popover,
  RadioControl,
  RangeControl,
  ResizableBox,
  ResponsiveWrapper,
  SandBox,
  ScrollLock,
  SearchControl,
  SelectControl,
  Slot,
  SlotFillProvider,
  Snackbar,
  SnackbarList,
  Spinner,
  TabPanel,
  TextControl,
  TextareaControl,
  TimePicker,
  ToggleControl,
  Toolbar,
  ToolbarButton,
  ToolbarGroup,
  Tooltip,
  TreeSelect
} = wp.components || {};

// For @wordpress/i18n
export const { __, _x, _n, _nx, sprintf, setLocaleData } = wp.i18n || {};

// For @wordpress/api-fetch - default export
export const apiFetch = wp.apiFetch;

// For @wordpress/data
export const {
  select,
  dispatch,
  subscribe,
  registerStore,
  createReduxStore,
  register,
  useSelect,
  useDispatch,
  withSelect,
  withDispatch
} = wp.data || {};

// For @wordpress/hooks
export const { addAction, addFilter, removeAction, removeFilter, doAction, applyFilters } = wp.hooks || {};

// For @wordpress/icons - export the whole icons object
export const icons = wp.icons || {};

// For @wordpress/plugins
export const { registerPlugin, unregisterPlugin, getPlugins, getPlugin } = wp.plugins || {};

// For @wordpress/blocks
export const {
  registerBlockType,
  unregisterBlockType,
  getBlockType,
  getBlockTypes,
  createBlock,
  cloneBlock,
  parseBlockAttributes
} = wp.blocks || {};

// For @wordpress/block-editor
export const blockEditor = wp.blockEditor || {};

// For @wordpress/editor
export const editor = wp.editor || {};

// For @wordpress/compose
export const compose = wp.compose || {};

// For @wordpress/date
export const date = wp.date || {};

// For @wordpress/edit-post
export const editPost = wp.editPost || {};

// For @wordpress/rich-text
export const richText = wp.richText || {};

// For @wordpress/url
export const url = wp.url || {};

// Default export - the entire wp object
export default wp;
