/**
 * React Shim
 *
 * Re-exports React from WordPress's bundled version (React 18+)
 */

const React = window.React || {};
export default React;

// Extract all React exports
export const {
  // Components
  Component,
  PureComponent,
  Fragment,
  StrictMode,
  Suspense,

  // Higher-order functions
  lazy,
  memo,
  forwardRef,
  createRef,

  // Basic Hooks (React 16.8+)
  useCallback,
  useContext,
  useDebugValue,
  useEffect,
  useImperativeHandle,
  useLayoutEffect,
  useMemo,
  useReducer,
  useRef,
  useState,

  // React 18+ Hooks
  useId,
  useDeferredValue,
  useTransition,
  useSyncExternalStore,
  useInsertionEffect,

  // Context
  createContext,

  // Elements
  createElement,
  cloneElement,
  isValidElement,

  // Children utilities
  Children,

  // React 18+ features
  startTransition,

  // Profiler
  Profiler
} = React;
