/**
 * JSX Runtime Shim
 *
 * Implements `react/jsx-runtime` using WordPress' React (`wp-element`).
 *
 * This avoids bundling a potentially incompatible JSX runtime from `react`
 * (e.g. React 19 can create `react.transitional.element` which breaks when
 * WordPress renders with React 18).
 */

import { createElement, Fragment } from '@wordpress/element';

export { Fragment };

export function jsx(type, props, maybeKey) {
  if (maybeKey !== undefined) {
    return createElement(type, { ...(props || {}), key: maybeKey });
  }
  return createElement(type, props);
}

export const jsxs = jsx;
