/**
 * Editor Sidebar Component
 *
 * Main sidebar component for the Block Editor integration.
 * Uses window.wp.* directly to avoid ES module shim timing issues.
 *
 * @package
 */

// Import styles only - no @wordpress/* imports to avoid shim issues
import './styles.css';
import './panels/readability-panel.css';
import './panels/linking-suggestions-panel.css';
import './panels/headline-analyzer-panel.css';
// AI assistant panel is premium; exclude from free build.

// Import panels - these should also use window.wp.* directly
import ContentAnalysisPanel from './panels/ContentAnalysisPanel';
import LinkingSuggestionsPanel from './panels/LinkingSuggestionsPanel';
import HeadlineAnalyzerPanel from './panels/HeadlineAnalyzerPanel';

const EditorSidebar = () => {
  // Access WordPress APIs at render time
  const { __ } = window.wp.i18n;
  const { Panel, PanelBody } = window.wp.components;
  const { useSelect } = window.wp.data;

  // Get current post data
  const { postId, postType, postStatus } = useSelect((select) => {
    const { getCurrentPostId, getCurrentPostType, getEditedPostAttribute } = select('core/editor');
    return {
      postId: getCurrentPostId(),
      postType: getCurrentPostType(),
      postStatus: getEditedPostAttribute('status'),
    };
  }, []);


  return (
    <div className="prorank-editor-sidebar">
      <Panel>
        <PanelBody
          title={__('Content Analysis & SEO', 'prorank-seo')}
          initialOpen={true}
          className="prorank-panel-body"
        >
          <div className="prorank-panel-content">
            <ContentAnalysisPanel postId={postId} />
          </div>
        </PanelBody>

        <PanelBody
          title={__('Headline Analyzer', 'prorank-seo')}
          initialOpen={false}
          className="prorank-panel-body"
        >
          <div className="prorank-panel-content">
            <HeadlineAnalyzerPanel postId={postId} />
          </div>
        </PanelBody>

        <PanelBody
          title={__('Internal Linking Suggestions', 'prorank-seo')}
          initialOpen={false}
          className="prorank-panel-body"
        >
          <div className="prorank-panel-content">
            <LinkingSuggestionsPanel postId={postId} />
          </div>
        </PanelBody>

      </Panel>

      {/* Debug info in development */}
    </div>
  );
};

export default EditorSidebar;
