/**
 * Status Badge Component
 * 
 * Colored pill-style badge for status indicators
 * 
 * @package ProRank\SEO
 */

/**
 * StatusBadge Component
 * 
 * @param {Object} props
 * @param {string} props.status - Status type: "success" | "warning" | "error" | "info" | "neutral"
 * @param {string} props.children - Badge text content
 * @param {string} props.size - Badge size: "small" | "medium"
 * @param {boolean} props.dot - Show status dot before text
 */
const StatusBadge = ({ 
  status = "neutral",
  size = "medium",
  dot = false,
  children 
}) => {
  const sizeClass = size === "small" ? "pr-badge--sm" : "";
  
  return (
    <span className={`pr-badge pr-badge--${status} ${sizeClass}`}>
      {dot && <span className="pr-badge__dot" />}
      {children}
      
      <style>{`
        .pr-badge {
          display: inline-flex;
          align-items: center;
          gap: 4px;
          padding: 2px 8px;
          font-size: 11px;
          font-weight: 600;
          line-height: 1.25;
          border-radius: 9999px;
          white-space: nowrap;
        }
        
        .pr-badge--sm {
          padding: 1px 6px;
          font-size: 10px;
        }
        
        .pr-badge--success {
          color: var(--pr-success, #3b82f6);
          background: var(--pr-success-light, #D1FAE5);
        }
        
        .pr-badge--warning {
          color: #996800;
          background: var(--pr-warning-light, #FEF3C7);
        }
        
        .pr-badge--error {
          color: var(--pr-error, #DC2626);
          background: var(--pr-error-light, #FEE2E2);
        }
        
        .pr-badge--info {
          color: var(--pr-info, #3B82F6);
          background: var(--pr-info-light, #DBEAFE);
        }
        
        .pr-badge--neutral {
          color: var(--pr-text-secondary, #6B7280);
          background: var(--pr-background-subtle, #F9FAFB);
        }
        
        .pr-badge__dot {
          width: 6px;
          height: 6px;
          border-radius: 50%;
          background: currentColor;
          flex-shrink: 0;
        }
      `}</style>
    </span>
  );
};

export default StatusBadge;
