/**
 * ProRank SEO Meta Box Shell (Free)
 *
 * Tabbed container for post editor meta box.
 */

import { __ } from '@wordpress/i18n';
import { TabPanel } from '@wordpress/components';

import MetaTabContent from './MetaTabContent.jsx';
import SocialTabContent from './SocialTabContent.jsx';
import SchemaTabContent from './SchemaTabContent.jsx';

const tabs = [
  {
    name: 'meta',
    title: __('Meta', 'prorank-seo'),
    className: 'prorank-tab-meta',
    content: MetaTabContent,
  },
  {
    name: 'social',
    title: __('Social', 'prorank-seo'),
    className: 'prorank-tab-social',
    content: SocialTabContent,
  },
  {
    name: 'schema',
    title: __('Schema', 'prorank-seo'),
    className: 'prorank-tab-schema',
    content: SchemaTabContent,
  },
];

const MetaBoxShell = () => {
  const metaboxData = window.prorankMetaboxData || {};
  const postId = Number(metaboxData.postId || 0);

  return (
    <div className="prorank-metabox-shell">
      <TabPanel
        className="prorank-metabox-tabs"
        activeClass="is-active"
        tabs={tabs.map((tab) => ({
          name: tab.name,
          title: tab.title,
          className: tab.className,
        }))}
      >
        {(tab) => {
          const TabContent = tabs.find((t) => t.name === tab.name)?.content;
          return TabContent ? <TabContent postId={postId} /> : null;
        }}
      </TabPanel>
    </div>
  );
};

export default MetaBoxShell;
