import { createContext, useContext, useState, useEffect, useCallback } from '@wordpress/element';

const EditorLicenseContext = createContext({
  currentTier: 'free',
  isDeveloperMode: false,
  isTierActive: () => true,
  loading: true,
});

export const EditorLicenseProvider = ({ children }) => {
  const [currentTier, setCurrentTier] = useState('free');
  const [isDeveloperMode, setIsDeveloperMode] = useState(false);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    setCurrentTier('free');
    setIsDeveloperMode(false);
    setLoading(false);
  }, []);

  const isTierActive = useCallback(() => true, []);

  return (
    <EditorLicenseContext.Provider
      value={{ currentTier, isDeveloperMode, isTierActive, loading }}
    >
      {children}
    </EditorLicenseContext.Provider>
  );
};

export const useEditorLicense = () => {
  const context = useContext(EditorLicenseContext);
  if (!context) {
    throw new Error('useEditorLicense must be used within an EditorLicenseProvider');
  }
  return context;
};
