/**
 * Settings validation schema for Redirects
 * Auto-generated from baseline.json
 * 
 * @module TechnicalSEO/Redirects
 * @since 0.1.0
 */

import { z } from 'zod';

/**
 * Settings schema for Redirects
 */
export const RedirectsSchema = z.object({
  enable_redirects: z.boolean().default(true),  // Enable redirect management
  default_redirect_type: z.enum(['301', '302', '303', '307', '308']).default('301'),  // Default redirect type for new redirects
  enable_auto_redirects: z.boolean().default(true),  // Automatically create redirects when URLs change
  enable_404_monitoring: z.boolean().default(true),  // Monitor and log 404 errors
  monitoring_404_threshold: z.number().int().min(1).max(1000).default(10),  // Number of 404 hits before suggesting redirect
  redirect_cache_expiry: z.number().int().min(0).max(86400).default(3600),  // Redirect cache expiry in seconds
  enable_regex_redirects: z.boolean().default(false),  // Enable regular expression redirects
  redirect_log_days: z.number().int().min(0).max(365).default(30),  // Days to keep redirect logs
  enable_redirect_chains_detection: z.boolean().default(true),  // Detect and warn about redirect chains
  max_redirects_per_request: z.number().int().min(1).max(10).default(3),  // Maximum redirect hops allowed
});

/**
 * TypeScript type for Redirects settings
 */
export type RedirectsSettings = z.infer<typeof RedirectsSchema>;

/**
 * Default values for Redirects settings
 */
export const RedirectsDefaults: RedirectsSettings = RedirectsSchema.parse({});

/**
 * Validate Redirects settings
 */
export function validateRedirectsSettings(data: unknown): RedirectsSettings {
  return RedirectsSchema.parse(data);
}

/**
 * Safely validate Redirects settings (returns validation result)
 */
export function safeValidateRedirectsSettings(data: unknown) {
  return RedirectsSchema.safeParse(data);
}
