/**
 * Settings validation schema for TitlesMeta
 * Auto-generated from baseline.json
 * 
 * @module OnPageSEO/TitlesMeta
 * @since 0.1.0
 */

import { z } from 'zod';

/**
 * Settings schema for TitlesMeta
 */
export const TitlesMetaSchema = z.object({
  title_separator: z.enum(['-', '|', '•', '–', '—', '»', '«']).default('-'),  // Separator between title parts
  homepage_title: z.string().max(60).default(''),  // Custom homepage title
  homepage_meta_description: z.string().max(160).default(''),  // Custom homepage meta description
  title_patterns: z.object({
    404: z.string(),
    post: z.string(),
    page: z.string(),
    archive: z.string(),
    search: z.string()
  }).default({"404":"Page Not Found %%sep%% %%sitename%%","post":"%%title%% %%sep%% %%sitename%%","page":"%%title%% %%sep%% %%sitename%%","archive":"%%term_title%% Archives %%sep%% %%sitename%%","search":"Search Results for %%searchphrase%% %%sep%% %%sitename%%"}),  // Title patterns for different content types
  force_rewrite_titles: z.boolean().default(true),  // Force rewrite of title tags
  noindex_empty_archives: z.boolean().default(true),  // Set noindex on empty archive pages
  noindex_paginated_pages: z.boolean().default(false),  // Set noindex on paginated pages
  disable_author_archives: z.boolean().default(false),  // Disable author archive pages
  disable_date_archives: z.boolean().default(false),  // Disable date-based archive pages
  open_graph_enabled: z.boolean().default(true),  // Enable Open Graph meta tags
  twitter_card_type: z.enum(['summary', 'summary_large_image']).default('summary_large_image'),  // Default Twitter Card type
});

/**
 * TypeScript type for TitlesMeta settings
 */
export type TitlesMetaSettings = z.infer<typeof TitlesMetaSchema>;

/**
 * Default values for TitlesMeta settings
 */
export const TitlesMetaDefaults: TitlesMetaSettings = TitlesMetaSchema.parse({});

/**
 * Validate TitlesMeta settings
 */
export function validateTitlesMetaSettings(data: unknown): TitlesMetaSettings {
  return TitlesMetaSchema.parse(data);
}

/**
 * Safely validate TitlesMeta settings (returns validation result)
 */
export function safeValidateTitlesMetaSettings(data: unknown) {
  return TitlesMetaSchema.safeParse(data);
}
