/**
 * ReactDOM Shim
 *
 * Re-exports ReactDOM from WordPress's bundled version (React 18+)
 */

const ReactDOM = window.ReactDOM || {};
export default ReactDOM;

// Export all ReactDOM methods
export const {
  render,
  hydrate,
  unmountComponentAtNode,
  findDOMNode,
  createPortal,
  flushSync,

  // React 18+ methods
  createRoot,
  hydrateRoot,

  // Unstable/internal APIs (used by some libraries)
  unstable_batchedUpdates,
  unstable_renderSubtreeIntoContainer,

  // Server-side rendering
  version
} = ReactDOM;
