/**
 * ReactDOM/client Shim
 *
 * Re-exports ReactDOM client APIs from WordPress's bundled version (React 18+)
 */

const ReactDOM = window.ReactDOM || {};

// React 18 client APIs
export const createRoot = ReactDOM.createRoot || (() => ({
  render: () => console.warn('createRoot not available'),
  unmount: () => {}
}));

export const hydrateRoot = ReactDOM.hydrateRoot || (() => ({
  render: () => console.warn('hydrateRoot not available'),
  unmount: () => {}
}));

export default { createRoot, hydrateRoot };
