import React from 'react';
import { Card, Button } from '../../../components/ui';
import { __ } from '@wordpress/i18n';
import { external } from '@wordpress/icons';

const DocumentationTab = ({ addNotice }) => {
  return (
    <div className="prorank-documentation-tab">
      {/* Hero Section */}
      <Card className="prorank-card--modern prorank-card--hero">
        <div className="prorank-card-body prorank-doc-hero">
          <div className="prorank-doc-hero-content">
            <h2>{__('ProRank SEO Documentation', 'prorank-seo')}</h2>
            <p>
              {__(
                'Comprehensive guides, tutorials, and API reference to help you get the most out of ProRank SEO.',
                'prorank-seo'
              )}
            </p>
            <Button
              variant="primary"
              icon={external}
              onClick={() => window.open('https://prorank.io/docs', '_blank')}
            >
              {__('Browse Full Documentation', 'prorank-seo')}
            </Button>
          </div>
        </div>
      </Card>

      {/* Support Section */}
      <Card className="prorank-card--modern prorank-card--support">
        <div className="prorank-card-body prorank-support-cta">
          <div className="support-content">
            <h3>{__('Need More Help?', 'prorank-seo')}</h3>
            <p>
              {__(
                "Can't find what you're looking for? Our support team is here to help.",
                'prorank-seo'
              )}
            </p>
          </div>
          <div className="support-actions">
            <Button
              variant="secondary"
              onClick={() => window.open('https://prorank.io/support', '_blank')}
            >
              {__('Contact Support', 'prorank-seo')}
            </Button>
            <Button
              variant="link"
              onClick={() => window.open('https://prorank.io/docs/changelog', '_blank')}
            >
              {__('View Changelog', 'prorank-seo')}
            </Button>
          </div>
        </div>
      </Card>
    </div>
  );
};

export default DocumentationTab;
