import React from 'react';
import { Card, Button } from '../../../components/ui';
import { __ } from '@wordpress/i18n';

const ChangelogTab = () => {
  const currentVersion = window.prorankSupport?.version || '1.0.3';

  return (
    <div className="prorank-changelog-tab">
      <Card className="pr-mb-6">
        <div className="pr-p-6">
          <h3 className="pr-text-lg pr-font-semibold pr-mb-2">
            {__('Current Version', 'prorank-seo')}
          </h3>
          <div className="pr-flex pr-items-center pr-gap-3">
            <span className="pr-text-3xl pr-font-bold pr-text-blue-600">{currentVersion}</span>
          </div>
        </div>
      </Card>

      <Card>
        <div className="pr-p-6 pr-text-center">
          <h3 className="pr-text-xl pr-font-semibold pr-mb-4">
            {__('View Full Changelog', 'prorank-seo')}
          </h3>
          <p className="pr-text-gray-600 pr-mb-6">
            {__('See all release notes, new features, and bug fixes on our website.', 'prorank-seo')}
          </p>
          <div className="pr-flex pr-justify-center pr-gap-4">
            <Button
              variant="primary"
              href="https://prorank.io/changelog"
              target="_blank"
            >
              {__('View Changelog', 'prorank-seo')}
            </Button>
            <Button
              variant="secondary"
              href="https://wordpress.org/plugins/prorank-seo/#developers"
              target="_blank"
            >
              {__('WordPress.org', 'prorank-seo')}
            </Button>
          </div>
        </div>
      </Card>
    </div>
  );
};

export default ChangelogTab;
