import { useState } from '@wordpress/element';
import { __ } from '@wordpress/i18n';
import { QueryClient, QueryClientProvider } from '@tanstack/react-query';
import { NotificationProvider } from '../../contexts/NotificationContext';
import { SettingsProvider } from '../../contexts/SettingsContext';
import PageHeader from '../../components/PageHeader';
import ModuleNav from '../../components/ModuleNav';
import headerBadges from '../../utils/headerBadges';

// Import global styles for ModuleNav and other components
import '../../styles/main.css';

// Import tabs (free version - no license/version tabs)
import DocumentationTab from './tabs/DocumentationTab';
import FeedbackTab from './tabs/FeedbackTab';
import ChangelogTab from './tabs/ChangelogTab';
import AdvancedSettingsTab from './tabs/AdvancedSettingsTab';

// Create a QueryClient instance for React Query
const queryClient = new QueryClient({
  defaultOptions: {
    queries: {
      staleTime: 5 * 60 * 1000,
      gcTime: 10 * 60 * 1000,
      retry: 1,
      refetchOnWindowFocus: false,
    },
  },
});

const SupportAccountPage = () => {
  const [activeTab, setActiveTab] = useState('documentation');

  const tabs = [
    { id: 'documentation', label: __('Documentation', 'prorank-seo'), component: DocumentationTab },
    { id: 'feedback', label: __('Feedback', 'prorank-seo'), component: FeedbackTab },
    { id: 'changelog', label: __('Changelog', 'prorank-seo'), component: ChangelogTab },
    { id: 'advanced', label: __('Advanced Settings', 'prorank-seo'), component: AdvancedSettingsTab },
  ];

  const ActiveTabComponent = tabs.find(tab => tab.id === activeTab)?.component;

  return (
    <QueryClientProvider client={queryClient}>
      <SettingsProvider>
        <NotificationProvider>
          <div className="pr-min-h-screen pr-bg-gray-50">
            {/* Page Header */}
            <PageHeader
              title={__('Support & Account', 'prorank-seo')}
              subtitle={__('Get support, access documentation, and configure advanced settings', 'prorank-seo')}
              badges={headerBadges['support-account']}
            />

            {/* Main Content */}
            <div className="pr-p-8">
              {/* Module Navigation */}
              <ModuleNav
                modules={tabs.map((tab) => ({
                  id: tab.id,
                  label: tab.label,
                }))}
                activeModule={activeTab}
                onModuleChange={setActiveTab}
              />

              {/* Tab Content */}
              <div className="pr-mt-6">
                {ActiveTabComponent && <ActiveTabComponent />}
              </div>
            </div>
          </div>
        </NotificationProvider>
      </SettingsProvider>
    </QueryClientProvider>
  );
};

export default SupportAccountPage;
