import { useEffect } from '@wordpress/element';
import { __ } from '@wordpress/i18n';
import PageHeader from '../../components/PageHeader';
import BulkEditTab from './BulkEditTab';
import headerBadges from '../../utils/headerBadges';

const BulkEditPage = () => {
  useEffect(() => {
    document.title =
      __('Bulk Edit', 'prorank-seo') + ' ‹ ' + __('ProRank SEO', 'prorank-seo') + ' — WordPress';
  }, []);

  return (
    <div className="pr-space-y-6">
      <PageHeader
        title={__('Bulk Edit SEO', 'prorank-seo')}
        subtitle={__(
          'Edit SEO titles, meta descriptions, and focus keywords across multiple posts in one place.',
          'prorank-seo'
        )}
        badges={headerBadges['bulk-edit']}
      />

      <BulkEditTab />
    </div>
  );
};

export default BulkEditPage;
