import React from 'react';
import { createRoot } from 'react-dom/client';
import WelcomeModal from './WelcomeModal.jsx';

/**
 * Initialize onboarding modal
 */
document.addEventListener('DOMContentLoaded', () => {
  const container = document.getElementById('prorank-seo-onboarding-root');

  if (!container) {
    // Create container if it doesn't exist
    const newContainer = document.createElement('div');
    newContainer.id = 'prorank-seo-onboarding-root';
    document.body.appendChild(newContainer);

    const root = createRoot(newContainer);

    // Get data from localized script
    const { apiUrl, nonce } = window.prorankSEOOnboarding || {};

    if (!apiUrl || !nonce) {
      return;
    }

    root.render(
      <WelcomeModal
        isOpen={true}
        onClose={() => {
          // Cleanup after modal closes
          root.unmount();
          newContainer.remove();

          // Refresh page to show main admin interface
          window.location.reload();
        }}
        apiUrl={apiUrl}
        nonce={nonce}
      />
    );
  }
});
