/* global wp */
/**
 * Media Enhancements Entry Point
 *
 * @package
 */

import { initializeMediaEnhancements } from './MediaEnhancements';
import { initializeMediaLibraryEnhancements } from './MediaLibraryEnhancements';

// Initialize media enhancements when DOM is ready
const initEnhancements = () => {
  try {
    initializeMediaEnhancements();
  } catch (error) {}

  try {
    initializeMediaLibraryEnhancements();
  } catch (error) {}
};

if (typeof wp !== 'undefined' && wp.domReady) {
  wp.domReady(initEnhancements);
} else {
  // Fallback for environments where wp.domReady isn't available
  document.addEventListener('DOMContentLoaded', initEnhancements);
}
