/**
 * ProRank SEO Admin Entry Point
 *
 * This file is the main entry point for the admin JavaScript.
 */

// Ensure code-split chunks load from this plugin's `build/` directory.
import '../public-path';

// Initialize WordPress URL helpers immediately
import './utils/urls';
import setupApiFetch from './utils/setupApiFetch';

// WordPress URL helpers must be initialized first
// Global styles are imported in App.jsx

// WordPress dependencies
import domReady from '@wordpress/dom-ready';
import { render } from '@wordpress/element';

// Import the main App component
import App from './App';

// Import media enhancements
import './media';

// Configure apiFetch early so child effects always have nonce middleware.
setupApiFetch();

// Initialize when DOM is ready
domReady(() => {
  // Find all admin containers
  const containers = document.querySelectorAll('.prorank-admin-container, #prorank-admin-root');

  if (containers.length > 0) {
    containers.forEach((container) => {
      render(<App />, container);
    });
  } else {
  }
});
