/**
 * User Preferences Context
 *
 * @package
 * @since   0.1.0
 */

import React, { createContext, useContext } from 'react';
import { useUserPreferences } from '../hooks/useUserPreferences';

const UserPreferencesContext = createContext({
  preferences: {
    expert_mode: false,
    pinned_modules: [],
  },
  loading: true,
  saving: false,
  isExpertMode: false,
  pinnedModules: [],
  updatePreferences: () => {},
  toggleExpertMode: () => {},
  togglePinnedModule: () => {},
  isModulePinned: () => false,
  refetch: () => {},
});

/**
 * User Preferences Provider
 *
 * @param {Object         } props          Component props
 * @param {React.ReactNode} props.children Child components
 * @return {JSX.Element} Provider component
 */
export const UserPreferencesProvider = ({ children }) => {
  const userPreferences = useUserPreferences();

  return (
    <UserPreferencesContext.Provider value={userPreferences}>
      {children}
    </UserPreferencesContext.Provider>
  );
};

/**
 * Use User Preferences Context
 *
 * @return {Object} User preferences context value
 */
export const useUserPreferencesContext = () => {
  const context = useContext(UserPreferencesContext);

  if (!context) {
    throw new Error('useUserPreferencesContext must be used within UserPreferencesProvider');
  }

  return context;
};

export default UserPreferencesContext;
