import { useState } from '@wordpress/element';

const Tabs = ({ tabs = [], className = '', activeClass = 'is-active', defaultTab = 0, children }) => {
  const [activeTab, setActiveTab] = useState(defaultTab);

  return (
    <div className={`pr-tabs ${className}`}>
      <div className="pr-tabs__header pr-flex pr-border-b pr-border-gray-200">
        {tabs.map((tab, index) => (
          <button
            key={tab.name || index}
            className={`pr-tabs__tab pr-px-4 pr-py-3 pr-font-medium pr-text-sm pr-border-b-2 pr-transition-all pr-duration-300 ${
              activeTab === index
                ? `${activeClass} pr-border-primary-600 pr-text-primary-600`
                : 'pr-border-transparent pr-text-gray-600 hover:pr-text-gray-800 hover:pr-border-gray-300'
            }`}
            onClick={() => setActiveTab(index)}
            type="button"
          >
            {tab.title}
          </button>
        ))}
      </div>
      <div className="pr-tabs__content pr-mt-6">
        {children ? children(tabs[activeTab]) : tabs[activeTab]?.content}
      </div>
    </div>
  );
};

export default Tabs;
