/**
 * Spinner Component - ProRank SEO
 *
 * Loading spinner for indicating processing states
 */

import React from 'react';
import clsx from 'clsx';

const Spinner = ({ size = 'md', className = '' }) => {
  const sizeClasses = {
    sm: 'pr-w-4 pr-h-4',
    md: 'pr-w-5 pr-h-5',
    lg: 'pr-w-6 pr-h-6',
    xl: 'pr-w-8 pr-h-8',
  };

  return (
    <svg
      className={clsx('pr-animate-spin', sizeClasses[size], className)}
      xmlns="http://www.w3.org/2000/svg"
      fill="none"
      viewBox="0 0 24 24"
    >
      <circle
        className="pr-opacity-25"
        cx="12"
        cy="12"
        r="10"
        stroke="currentColor"
        strokeWidth="4"
      />
      <path
        className="pr-opacity-75"
        fill="currentColor"
        d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"
      />
    </svg>
  );
};

export default Spinner;
