const RangeInput = ({
  label,
  help,
  value = 0,
  onChange,
  min = 0,
  max = 100,
  step = 1,
  showValue = true,
  disabled = false,
  className = ''
}) => {
  const percentage = ((value - min) / (max - min)) * 100;
  const trackClassName = [
    'pr-w-full pr-h-2 pr-bg-gray-200 pr-rounded-lg pr-appearance-none pr-transition-all pr-duration-300',
    disabled ? 'pr-cursor-not-allowed pr-opacity-50' : 'pr-cursor-pointer',
  ].join(' ');

  return (
    <div className={`pr-range-input ${className}`}>
      {label && (
        <label className="pr-block pr-text-sm pr-font-medium pr-text-gray-900 pr-mb-2">
          {label}
          {showValue && (
            <span className="pr-ml-2 pr-text-primary-600 pr-font-semibold">{value}</span>
          )}
        </label>
      )}
      <div className="pr-relative pr-w-full">
        <input
          type="range"
          value={value}
          onChange={(e) => onChange(Number(e.target.value))}
          min={min}
          max={max}
          step={step}
          disabled={disabled}
          className={trackClassName}
          style={{
            background: `linear-gradient(to right, #2563eb 0%, #2563eb ${percentage}%, #e5e7eb ${percentage}%, #e5e7eb 100%)`
          }}
        />
      </div>
      {help && (
        <p className="pr-mt-1 pr-text-sm pr-text-gray-600">{help}</p>
      )}
    </div>
  );
};

export default RangeInput;
