const Radio = ({ label, help, selected, options = [], onChange, className = '' }) => {
  return (
    <div className={`pr-radio-control ${className}`}>
      {label && (
        <label className="pr-block pr-text-sm pr-font-medium pr-text-gray-900 pr-mb-2">
          {label}
        </label>
      )}
      <div className="pr-space-y-2">
        {options.map((option) => (
          <label
            key={option.value}
            className="pr-flex pr-items-center pr-cursor-pointer pr-transition-all pr-duration-300"
          >
            <input
              type="radio"
              value={option.value}
              checked={selected === option.value}
              onChange={() => onChange(option.value)}
              className="pr-w-4 pr-h-4 pr-text-primary-600 pr-border-gray-300 focus:pr-ring-primary-500 focus:pr-ring-2 pr-transition-all pr-duration-300"
            />
            <span className="pr-ml-2 pr-text-sm pr-text-gray-700">{option.label}</span>
          </label>
        ))}
      </div>
      {help && (
        <p className="pr-mt-2 pr-text-sm pr-text-gray-600">{help}</p>
      )}
    </div>
  );
};

export default Radio;
