/**
 * ProgressBar Component - ProRank SEO
 *
 * Progress bar for indicating task completion
 */

import React from 'react';
import clsx from 'clsx';

const ProgressBar = ({ value = 0, max = 100, className = '', showLabel = false }) => {
  const percentage = Math.min(Math.max((value / max) * 100, 0), 100);

  return (
    <div className={clsx('pr-w-full', className)}>
      <div className="pr-relative pr-w-full pr-h-2 pr-bg-gray-200 pr-rounded-full pr-overflow-hidden">
        <div
          className="pr-absolute pr-inset-y-0 pr-left-0 pr-bg-primary-500 pr-transition-all pr-duration-300"
          style={{ width: `${percentage}%` }}
        />
      </div>
      {showLabel && (
        <span className="pr-text-xs pr-text-gray-600 pr-mt-1 pr-block">
          {Math.round(percentage)}%
        </span>
      )}
    </div>
  );
};

export default ProgressBar;
