/**
 * Badge Component - ProRank SEO
 *
 * Premium badge component for status indicators and labels.
 * Supports multiple variants and sizes.
 *
 * @example
 * <Badge variant="success">Active</Badge>
 * <Badge variant="warning" size="sm">Pending</Badge>
 * <Badge variant="error">Failed</Badge>
 */

import React from 'react';
import clsx from 'clsx';

const Badge = ({
  children,
  variant = 'default',
  size = 'md',
  rounded = true,
  icon: Icon,
  className = '',
  ...props
}) => {
  // Size variants
  const sizeStyles = {
    sm: clsx('pr-px-2 pr-py-0.5 pr-text-xs', Icon && 'pr-gap-1'),
    md: clsx('pr-px-2.5 pr-py-0.5 pr-text-xs', Icon && 'pr-gap-1.5'),
    lg: clsx('pr-px-3 pr-py-1 pr-text-sm', Icon && 'pr-gap-2'),
  };

  // Icon sizes
  const iconSizes = {
    sm: 'pr-w-3 pr-h-3',
    md: 'pr-w-3.5 pr-h-3.5',
    lg: 'pr-w-4 pr-h-4',
  };

  // Variant styles
  const variantStyles = {
    default: 'pr-bg-gray-100 pr-text-gray-800',
    primary: 'pr-bg-primary-100 pr-text-primary-800',
    secondary: 'pr-bg-gray-100 pr-text-gray-700',
    success: 'pr-bg-success-100 pr-text-success-800',
    warning: 'pr-bg-warning-100 pr-text-warning-800',
    error: 'pr-bg-error-100 pr-text-error-800',
    info: 'pr-bg-info-100 pr-text-info-800',
    purple: 'pr-bg-purple-100 pr-text-purple-800',
  };

  // Badge styles
  const badgeStyles = clsx(
    'pr-inline-flex',
    'pr-items-center',
    'pr-font-medium',
    sizeStyles[size],
    variantStyles[variant],
    {
      'pr-rounded-full': rounded,
      'pr-rounded': !rounded,
    },
    className
  );

  return (
    <span className={badgeStyles} {...props}>
      {Icon && <Icon className={iconSizes[size]} />}
      {children || ''}
    </span>
  );
};

Badge.displayName = 'Badge';

export default Badge;
