/**
 * Typography Components Tests
 *
 * Basic tests for Typography components
 *
 * @package
 */

import { render } from '@testing-library/react';
import { Divider, Heading, Text } from './index';

describe('Typography Components', () => {
  describe('Divider', () => {
    it('renders without crashing', () => {
      const { container } = render(<hr />);
      expect(container.querySelector('hr')).toBeInTheDocument();
    });

    it('accepts custom className', () => {
      const { container } = render(<Divider className="custom-class" />);
      expect(container.querySelector('hr')).toHaveClass('custom-class');
    });
  });

  describe('Heading', () => {
    it('renders with default h2 tag', () => {
      const { container } = render(<Heading>Test Heading</Heading>);
      expect(container.querySelector('h2')).toBeInTheDocument();
      expect(container.querySelector('h2')).toHaveTextContent('Test Heading');
    });

    it('renders with specified heading level', () => {
      const { container } = render(<Heading level={3}>H3 Heading</Heading>);
      expect(container.querySelector('h3')).toBeInTheDocument();
    });

    it('applies size and weight classes', () => {
      const { container } = render(
        <Heading size="large" weight="bold">
          Styled Heading
        </Heading>
      );
      const heading = container.querySelector('h2');
      expect(heading).toHaveClass('prorank-heading--size-large');
      expect(heading).toHaveClass('prorank-heading--weight-bold');
    });
  });

  describe('Text', () => {
    it('renders with default p tag', () => {
      const { container } = render(<p>Test text content</p>);
      expect(container.querySelector('p')).toBeInTheDocument();
      expect(container.querySelector('p')).toHaveTextContent('Test text content');
    });

    it('renders with specified element', () => {
      const { container } = render(<Text as="span">Span text</Text>);
      expect(container.querySelector('span')).toBeInTheDocument();
    });

    it('applies variant classes', () => {
      const { container } = render(<Text variant="muted">Muted text</Text>);
      expect(container.querySelector('p')).toHaveClass('prorank-text--muted');
    });
  });
});
