# Typography Components

Stable, accessible typography components for ProRank SEO that replace WordPress's experimental components.

## Components

### Divider
A horizontal rule with consistent styling that matches the WordPress admin theme.

```jsx
import { Divider } from '../../../components/common/Typography';

// Basic usage
<Divider />

// With custom class
<Divider className="my-custom-divider" />
```

### Heading
Semantic heading component with design system styling.

```jsx
import { Heading } from '../../../components/common/Typography';

// Basic usage (defaults to h2)
<Heading>My Heading</Heading>

// Different heading levels
<Heading level={1}>H1 Heading</Heading>
<Heading level={3}>H3 Heading</Heading>

// Size variants
<Heading size="small">Small Heading</Heading>
<Heading size="medium">Medium Heading</Heading>
<Heading size="large">Large Heading</Heading>

// Font weights
<Heading weight="normal">Normal Weight</Heading>
<Heading weight="semibold">Semibold Weight</Heading>
<Heading weight="bold">Bold Weight</Heading>

// Combined props
<Heading level={3} size="large" weight="bold" className="section-title">
    Section Title
</Heading>
```

### Text
Paragraph text component with multiple variants and styling options.

```jsx
import { Text } from '../../../components/common/Typography';

// Basic usage
<Text>Regular body text</Text>

// Variants
<Text variant="body">Body text (default)</Text>
<Text variant="muted">Muted text for secondary content</Text>
<Text variant="caption">Caption text with italic style</Text>
<Text variant="error">Error message text</Text>
<Text variant="success">Success message text</Text>

// Sizes
<Text size="small">Small text (12px)</Text>
<Text size="medium">Medium text (13px - default)</Text>
<Text size="large">Large text (14px)</Text>

// Font weights
<Text weight="normal">Normal weight text</Text>
<Text weight="medium">Medium weight text</Text>
<Text weight="semibold">Semibold weight text</Text>
<Text weight="bold">Bold weight text</Text>

// Render as different elements
<Text as="span">Inline text</Text>
<Text as="div">Block text</Text>

// Combined props
<Text variant="muted" size="small" as="span" className="help-text">
    This is help text
</Text>
```

## Features

- ✅ **Stable API** - No experimental WordPress components
- ✅ **Accessible** - Semantic HTML with proper ARIA support
- ✅ **Dark Mode** - Automatic dark mode support via CSS custom properties
- ✅ **High Contrast** - Enhanced borders and opacity for accessibility
- ✅ **Reduced Motion** - Respects user's motion preferences
- ✅ **TypeScript-ready** - JSDoc comments for IDE support
- ✅ **CSS Modules** - Scoped styles following ProRank's architecture
- ✅ **WordPress Integration** - Uses WordPress admin color scheme variables

## Migration from Experimental Components

Replace WordPress experimental components:

```jsx
// Before
import { 
    __experimentalDivider as Divider,
    __experimentalHeading as Heading,
    __experimentalText as Text 
} from '@wordpress/components';

// After
import { Divider, Heading, Text } from '../../../components/common/Typography';
```

## Design Tokens

The components use WordPress admin CSS custom properties for consistency:

- `--wp-admin-theme-color-darker-20` - Primary text color
- `--wp-admin-theme-color-darker-10` - Secondary/muted text color
- `--wp-g2-grid-base-size-2` - Standard spacing

## Browser Support

- Modern browsers (Chrome, Firefox, Safari, Edge)
- IE11 not supported (following WordPress 5.8+)
