/**
 * Sidebar Shell Component
 *
 * Common wrapper component for sidebar panels with consistent styling.
 *
 * @package
 * @since   0.1.0
 */

import { __ } from '@wordpress/i18n';
import { Button } from '@wordpress/components';
import { close } from '@wordpress/icons';

const SidebarShell = ({ title, onClose, children, className = '' }) => {
  return (
    <div className={`prorank-sidebar-shell ${className}`}>
      <div className="prorank-sidebar-header">
        <h2 className="prorank-sidebar-title">{title}</h2>
        {onClose && (
          <Button
            className="prorank-sidebar-close"
            icon={close}
            label={__('Close', 'prorank-seo')}
            onClick={onClose}
            size="small"
          />
        )}
      </div>
      <div className="prorank-sidebar-content">{children}</div>
    </div>
  );
};

export default SidebarShell;
