/* global sprintf */
import { __, sprintf } from '@wordpress/i18n';
import { SelectControl, Button } from '@wordpress/components';
import { useState } from '@wordpress/element';

const BulkActions = ({ selectedCount, actions, onAction }) => {
  const [selectedAction, setSelectedAction] = useState('');

  const handleApply = () => {
    if (selectedAction && onAction) {
      onAction(selectedAction);
      setSelectedAction('');
    }
  };

  return (
    <div className="prorank-bulk-actions">
      <span className="prorank-selected-count">
        {
          /* translators: %d: number of selected items */
          sprintf(__('%d selected', 'prorank-seo'), selectedCount)
        }
      </span>

      <div className="prorank-bulk-controls">
        <SelectControl
          value={selectedAction}
          options={[{ label: __('Bulk Actions', 'prorank-seo'), value: '' }, ...actions]}
          onChange={setSelectedAction}
          className="prorank-bulk-select"
        />

        <Button variant="secondary" onClick={handleApply} disabled={!selectedAction}>
          {__('Apply', 'prorank-seo')}
        </Button>
      </div>
    </div>
  );
};

export default BulkActions;
