/**
 * Unified Stats Grid Component
 *
 * Consistent grid layout for stat cards across all pages
 */

const StatsGrid = ({ children, columns = 4 }) => {
  const gridClasses = {
    2: 'pr-grid-cols-1 md:pr-grid-cols-2',
    3: 'pr-grid-cols-1 md:pr-grid-cols-2 lg:pr-grid-cols-3',
    4: 'pr-grid-cols-1 md:pr-grid-cols-2 lg:pr-grid-cols-4',
    5: 'pr-grid-cols-1 md:pr-grid-cols-2 lg:pr-grid-cols-3 xl:pr-grid-cols-5',
  };

  return (
    <div className={`pr-grid ${gridClasses[columns]} pr-gap-6 pr-mb-8`}>
      {children}
    </div>
  );
};

export default StatsGrid;
