/**
 * StatCard Component
 *
 * Small stat display card for page headers
 */

const StatCard = ({ icon: Icon, value, label, trend }) => {
  return (
    <div className="pr-bg-white pr-rounded-lg pr-p-4 pr-shadow-sm pr-border pr-border-gray-200 pr-min-w-[140px]">
      <div className="pr-flex pr-items-center pr-gap-3">
        {Icon && (
          <div className="pr-flex-shrink-0">
            <Icon className="pr-w-5 pr-h-5 pr-text-gray-600" aria-hidden="true" />
          </div>
        )}
        <div className="pr-flex-1 pr-min-w-0">
          <div className="pr-text-2xl pr-font-semibold pr-text-gray-900 pr-truncate">
            {value}
          </div>
          <div className="pr-text-xs pr-text-gray-600 pr-truncate pr-mt-0.5">
            {label}
          </div>
          {trend !== undefined && (
            <div className={`pr-text-xs pr-mt-1 ${trend >= 0 ? 'pr-text-green-600' : 'pr-text-red-600'}`}>
              {trend >= 0 ? '↑' : '↓'} {Math.abs(trend)}%
            </div>
          )}
        </div>
      </div>
    </div>
  );
};

export default StatCard;
