/**
 * Setting Toggle Component - Reusable toggle with label and help text
 */

import { __ } from '@wordpress/i18n';
import ProrankToggle from './ProrankToggle';
import * as React from 'react';

interface SettingToggleProps {
  label: string;
  helpText?: string;
  checked: boolean;
  onChange: (value: boolean) => void;
  disabled?: boolean;
  className?: string;
}

const SettingToggle: React.FC<SettingToggleProps> = ({
  label,
  helpText,
  checked,
  onChange,
  disabled = false,
  className = '',
}) => {
  return (
    <div className={`prorank-toggle ${className}`}>
      <div className="prorank-toggle-label">
        <strong>{label}</strong>
        {helpText && <span>{helpText}</span>}
      </div>
      <ProrankToggle
        checked={checked}
        onChange={onChange}
        disabled={disabled}
      />
    </div>
  );
};

export default SettingToggle;