import { useState, useEffect } from '@wordpress/element';
import * as React from 'react';

/**
 * ProRank Toggle Track Component
 * Module header toggle with ON/OFF text display
 * Used for main module enable/disable toggles
 */

interface ProrankToggleTrackProps {
  checked?: boolean;
  onChange?: (checked: boolean) => void;
  disabled?: boolean;
  showText?: boolean;
  className?: string;
}

const ProrankToggleTrack: React.FC<ProrankToggleTrackProps> = ({
  checked = false,
  onChange,
  disabled = false,
  showText = true,
  className = ''
}) => {
  const [isChecked, setIsChecked] = useState(checked);

  useEffect(() => {
    setIsChecked(checked);
  }, [checked]);

  const handleToggle = () => {
    if (!disabled) {
      const newValue = !isChecked;
      setIsChecked(newValue);
      onChange?.(newValue);
    }
  };

  return (
    <button
      type="button"
      role="switch"
      aria-checked={isChecked}
      className={`prorank-toggle-track ${isChecked ? 'prorank-toggle-track--on' : 'prorank-toggle-track--off'} ${disabled ? 'prorank-toggle-track--disabled' : ''} ${className}`}
      onClick={handleToggle}
      disabled={disabled}
    >
      <span className="prorank-toggle-track__slider" />
      {showText && (
        <span className="prorank-toggle-track__text">
          {isChecked ? 'ON' : 'OFF'}
        </span>
      )}
    </button>
  );
};

export default ProrankToggleTrack;
