/**
 * ProRank Spinner Component
 *
 * A loading spinner component.
 */

import { Spinner } from '@wordpress/components';
import * as React from 'react';

interface ProrankSpinnerProps {
  size?: number;
  className?: string;
  style?: React.CSSProperties;
}

const ProrankSpinner: React.FC<ProrankSpinnerProps> = ({
  size,
  className = '',
  style,
}) => {
  const spinnerStyle: React.CSSProperties = {
    ...style,
    ...(size ? { width: size, height: size } : {}),
  };

  return (
    <Spinner
      className={`prorank-spinner ${className}`}
      style={spinnerStyle}
    />
  );
};

export { ProrankSpinner };
export default ProrankSpinner;
