import React from 'react';

interface Option {
  value: string;
  label: string;
}

interface ProrankSelectProps {
  value: string;
  options: Option[];
  onChange: (value: string) => void;
  disabled?: boolean;
  className?: string;
}

const ProrankSelect: React.FC<ProrankSelectProps> = ({ value, options, onChange, disabled = false, className = '' }) => {
  return (
    <select
      className={`prorank-select ${className}`.trim()}
      value={value}
      onChange={(e) => onChange(e.target.value)}
      disabled={disabled}
    >
      {options.map((opt) => (
        <option key={opt.value} value={opt.value}>
          {opt.label}
        </option>
      ))}
    </select>
  );
};

export { ProrankSelect };
export default ProrankSelect;
