import React from 'react';

/**
 * ProRank Radio Group Component
 * Styled radio button group matching ProRank design standards
 */

interface RadioOption {
  value: string;
  label: string;
  disabled?: boolean;
}

interface ProrankRadioGroupProps {
  name: string;
  options: RadioOption[];
  value: string;
  onChange: (value: string) => void;
  className?: string;
  label?: string;
  help?: string;
  inline?: boolean;
}

const ProrankRadioGroup: React.FC<ProrankRadioGroupProps> = ({
  name,
  options,
  value,
  onChange,
  className = '',
  label,
  help,
  inline = true
}) => {
  return (
    <div className={`prorank-form-group ${className}`}>
      {label && <label className="prorank-form-label">{label}</label>}
      {help && <p className="prorank-form-help">{help}</p>}

      <div className={`prorank-radio-group ${inline ? '' : 'prorank-radio-group-vertical'}`}>
        {options.map((option) => (
          <label key={option.value} className={option.disabled ? 'disabled' : ''}>
            <input
              type="radio"
              name={name}
              value={option.value}
              checked={value === option.value}
              onChange={(e) => onChange(e.target.value)}
              disabled={option.disabled}
            />
            <span>{option.label}</span>
          </label>
        ))}
      </div>
    </div>
  );
};

export default ProrankRadioGroup;