/**
 * ProRank Progress Bar
 *
 * Simple progress indicator used across dashboards.
 */

import * as React from 'react';

export interface ProrankProgressBarProps extends React.HTMLAttributes<HTMLDivElement> {
  value: number;
  max?: number;
  barClassName?: string;
  showLabel?: boolean;
}

export const ProrankProgressBar: React.FC<ProrankProgressBarProps> = ({
  value,
  max = 100,
  className = '',
  barClassName = '',
  showLabel = false,
  ...props
}) => {
  const safeMax = max > 0 ? max : 100;
  const percent = Math.max(0, Math.min(100, (Number(value) / safeMax) * 100));

  return (
    <div className={`pr-w-full ${className}`} {...props}>
      <div className="pr-h-2 pr-w-full pr-rounded-full pr-bg-gray-200 pr-overflow-hidden">
        <div
          className={`pr-h-2 pr-rounded-full pr-bg-blue-600 pr-transition-[width] pr-duration-300 ${barClassName}`}
          style={{ width: `${percent}%` }}
        />
      </div>
      {showLabel ? (
        <div className="pr-mt-1 pr-text-xs pr-text-gray-600 pr-text-right">{Math.round(percent)}%</div>
      ) : null}
    </div>
  );
};

export default ProrankProgressBar;

