/**
 * ProRank Notice Component
 *
 * A styled notice/alert component.
 */

import { Notice } from '@wordpress/components';
import * as React from 'react';

interface ProrankNoticeProps {
  children: React.ReactNode;
  status?: 'success' | 'error' | 'warning' | 'info';
  isDismissible?: boolean;
  onDismiss?: () => void;
  className?: string;
  style?: React.CSSProperties;
  actions?: Array<{
    label: string;
    onClick: () => void;
    className?: string;
    variant?: 'primary' | 'secondary' | 'link';
  }>;
}

const ProrankNotice: React.FC<ProrankNoticeProps> = ({
  children,
  status = 'info',
  isDismissible = false,
  onDismiss,
  className = '',
  style,
  actions,
}) => {
  return (
    <Notice
      status={status}
      isDismissible={isDismissible}
      onDismiss={onDismiss}
      className={`prorank-notice prorank-notice--${status} ${className}`}
      style={style}
      actions={actions}
    >
      {children}
    </Notice>
  );
};

export { ProrankNotice };
export default ProrankNotice;
