import React from 'react';
import { ReactNode } from '@wordpress/element';

interface ProrankHeaderProps {
  title: string;
  description?: string;
  subtitle?: string;
  badges?: Array<{ label: string; variant?: string } | string>;
  children?: ReactNode;
}

/**
 * Unified header component with premium blue gradient and animated orange accent bar.
 */
const ProrankHeader: React.FC<ProrankHeaderProps> = ({ title, description, subtitle, badges, children }) => {
  const headerText = subtitle || description;
  const normalizedBadges = Array.isArray(badges)
    ? badges
      .map((badge) => {
        if (typeof badge === 'string') {
          return { label: badge };
        }
        return badge || null;
      })
      .filter(Boolean)
    : [];

  return (
    <div className="prorank-header">
      {/* Orange accent bar with pulse animation */}
      <div className="prorank-header-accent-bar" />
      {/* Moving wave effect on top of accent bar */}
      <div className="prorank-header-wave" />
      <div className="prorank-header-content">
        <div className="prorank-header-left">
          <h1>{title}</h1>
          {headerText && <p>{headerText}</p>}
          {normalizedBadges.length > 0 && (
            <div className="prorank-header-badges">
              {normalizedBadges.map((badge, index) => (
                <span
                  key={`${badge.label}-${index}`}
                  className={`prorank-header-badge${badge.variant ? ` prorank-header-badge--${badge.variant}` : ''}`}
                >
                  {badge.label}
                </span>
              ))}
            </div>
          )}
        </div>
        {children && (
          <div className="prorank-header-right">
            <div className="prorank-header-actions">{children}</div>
          </div>
        )}
      </div>
    </div>
  );
};

export default ProrankHeader;
