import React from 'react';

/**
 * ProrankDivider - Unified divider component
 */

interface ProrankDividerProps {
  margin?: 'small' | 'medium' | 'large';
  className?: string;
}

const ProrankDivider: React.FC<ProrankDividerProps> = ({
  margin = 'medium',
  className = ''
}) => {
  const marginClasses = {
    small: 'prorank-divider--small',
    medium: 'prorank-divider--medium',
    large: 'prorank-divider--large'
  };

  return (
    <hr className={`prorank-divider ${marginClasses[margin]} ${className}`} />
  );
};

ProrankDivider.displayName = 'ProrankDivider';

export { ProrankDivider };
export default ProrankDivider;