/**
 * ProRank Card Components
 *
 * Lightweight card primitives used across the admin UI.
 */

import * as React from 'react';

type DivProps = React.HTMLAttributes<HTMLDivElement>;

export interface ProrankCardProps extends DivProps {
  title?: React.ReactNode;
  description?: React.ReactNode;
  actions?: React.ReactNode;
}

export const ProrankCardHeader: React.FC<DivProps> = ({ className = '', children, ...props }) => (
  <div
    className={`pr-flex pr-items-start pr-justify-between pr-gap-4 pr-border-b pr-border-gray-100 pr-px-6 pr-py-4 ${className}`}
    {...props}
  >
    {children}
  </div>
);

export const ProrankCardBody: React.FC<DivProps> = ({ className = '', children, ...props }) => (
  <div className={`pr-p-6 ${className}`} {...props}>
    {children}
  </div>
);

export const ProrankCard: React.FC<ProrankCardProps> = ({
  title,
  description,
  actions,
  className = '',
  children,
  ...props
}) => {
  const hasHeader = Boolean(title || description || actions);

  return (
    <div className={`pr-bg-white pr-rounded-xl pr-shadow-sm pr-border pr-border-gray-100 ${className}`} {...props}>
      {hasHeader ? (
        <ProrankCardHeader>
          <div className="pr-min-w-0">
            {title ? <h3 className="pr-text-base pr-font-semibold pr-text-gray-900 pr-m-0">{title}</h3> : null}
            {description ? <p className="pr-mt-1 pr-text-sm pr-text-gray-600 pr-m-0">{description}</p> : null}
          </div>
          {actions ? <div className="pr-flex pr-items-center pr-gap-2">{actions}</div> : null}
        </ProrankCardHeader>
      ) : null}
      {children}
    </div>
  );
};

export default ProrankCard;

