/**
 * ProRank Button Component
 *
 * A styled button component that matches the ProRank design system.
 */

import { Button } from '@wordpress/components';
import * as React from 'react';

interface ProrankButtonProps {
  children: React.ReactNode;
  variant?: 'primary' | 'secondary' | 'tertiary' | 'link';
  size?: 'small' | 'default' | 'compact';
  disabled?: boolean;
  onClick?: (event: React.MouseEvent<HTMLButtonElement>) => void;
  className?: string;
  style?: React.CSSProperties;
  type?: 'button' | 'submit' | 'reset';
  icon?: React.ReactNode;
  iconPosition?: 'left' | 'right';
  isDestructive?: boolean;
  isBusy?: boolean;
  href?: string;
  target?: string;
}

const ProrankButton: React.FC<ProrankButtonProps> = ({
  children,
  variant = 'secondary',
  size = 'default',
  disabled = false,
  onClick,
  className = '',
  style,
  type = 'button',
  icon,
  iconPosition = 'left',
  isDestructive = false,
  isBusy = false,
  href,
  target,
}) => {
  const buttonClasses = [
    'prorank-button',
    `prorank-button--${variant}`,
    size !== 'default' ? `prorank-button--${size}` : '',
    isDestructive ? 'prorank-button--destructive' : '',
    className,
  ].filter(Boolean).join(' ');

  return (
    <Button
      variant={variant}
      disabled={disabled || isBusy}
      onClick={onClick}
      className={buttonClasses}
      style={style}
      icon={icon}
      iconPosition={iconPosition}
      isBusy={isBusy}
      href={href}
      target={target}
    >
      {children}
    </Button>
  );
};

export default ProrankButton;
